# 1 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino"
/*************************************************************************

*   Project     :  One Wire Net

*   Libraries   :  OneWireNet

*   Author      :  MAN's

*   Description :  for use with multi devices families at the same pin.

*                  warning: no negative temp is computed in this example.

*************************************************************************/
# 8 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino"
# 9 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino" 2
# 10 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino" 2

//some devices families.
# 21 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino"
const uint8_t OWPIN = 4;


OneWireNet ow(OWPIN);

char text[25];
uint8_t ROM[8];
uint8_t spad[9];


uint8_t numOfDevices;
uint8_t TEMP = 0;
uint8_t tf = 0;
uint8_t devCount = 1;

void OneWire_Tasks()
{
    
# 38 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino" 3
   __asm__ __volatile__ ("cli" ::: "memory")
# 38 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino"
        ; //during 1-wire proccess disable all interrupts
    devCount = 1;
    bool pup = ow.PUPdetect(); //check if pull-up resistor is attached
                                                          //on the 1-wire pin.
    if (!pup)
    {
        Serial.println("No pull up detected.");
        delay(500);
        return;
    }
    numOfDevices = ow.Count_Device(); //get the amouth of devices attached to the bus.
    Serial.println("---------------------------");
    Serial.print("Number of Devices Found: ");
    Serial.print(numOfDevices, 10);
    Serial.println("\r\n---------------------------");
    while (numOfDevices > 0) //Search devices attached to the bus
    { //one by one until numOfDevices > 0.
        ow.Search_Dev(ROM,0xF0); //Searches devices on the bus 1-wire
                                                          //and fill buffer with its ROM data.
        bool crc = ow.ChkCRC(ROM,0x07); //Do device CRC check
        sprintf(text,"Device ROM '%u': ", devCount++);
        Serial.print(text);
        for(uint8_t j = 6;j>0;j--) //Retrieve a unique device ROM code.
        { //from ROM array.
            sprintf(text,"%02X",ROM[j]); //format it to HEX 
            Serial.print(text); //show the sequence of that.
        }
        sprintf(text,"h - Code: (0x%02X)",ROM[0]); //get family code
        Serial.print(text); //show family code
        if (crc==true) Serial.print(" CRC OK "); //CRC for all devices if true.
        switch(ROM[0]) //Filter for somes device families
        {
            case 0x28: //if these families match
            case 0x10: //will promote its data retrieve.
            case 0x22:
                uint8_t ps = ow.Pwr_Type(ROM); //check the power type applied.
                if (ps)
                    Serial.print("POWERED  MODE ");
                else
                    Serial.print("PARASITE MODE ");
                ow.ConvTemp(ROM); //provide the temp conversion for that ROM

                ow.Select_Dev(ROM); //select that ROM because ConvTemp func cause 
                                                          //device reset.
                ow.ReadSPad(spad); //read scratchpad
                crc = ow.ChkCRC(spad, 0x08); //do CRC check with its contenet
                if ( crc ) //if CRC match, proccess the data
                { //with some know devices.
                    if(ROM[0] == 0x28 || ROM[0] == 0x22)
                    {
                            tf = spad[0] & 0x08?5:0;
                            TEMP = (spad[1] << 4);
                            TEMP |= (spad[0] >> 4);
                    }
                    else if(ROM[0] == 0x10 )
                    {
                            tf = spad[0] & 0x01?5:0;
                            TEMP = (spad[0] >> 1);
                    }
                    sprintf(text," Temp: %02i.%i %cC",TEMP,tf,176);
                    Serial.print("  ");
                    Serial.print(text);
                }
                else
                {
                  Serial.print(" Wrong SPAD CRC Detected.");
                }
                break;
            default:
                break;
        }
        String status ="";
        if (ROM[0] == 0x05) //Switch
        {
            Serial.print("Addressable Switch, ");
            static uint8_t isActive = 1;
            ow.Select_Dev(ROM); //Select device and turn on/off LED, but we could 
                                          //check PIO state before togle too.
            if(isActive)
            {
               status = "Turning LED On...";
               isActive = 0;
            }
            else
            {
                status = "Turning LED Off...";
                isActive = 1;
            }
        }
        if (ROM[0] == 0x29) //8 channel addressable switch
        {
            status = "8 channel Addressable Switch. (";
            ow.Select_Dev(ROM); //Select device
            ow.Issue_Cmd(0xF5); //issue command to access channel
            uint8_t PIO = ow.GetData(); //read channel data
            itoa((PIO & 0x0f),text,10);
            status += text;
            status += ")";

        }
        if (ROM[0] == 0x01) status = "IBUTTON nothing to do.";
        if (ROM[0] == 0x14) status = "EEPROM 512 Bit   R/W mode";
        if (ROM[0] == 0x23) status = "EEPROM 512 Bytes R/W mode";

        Serial.print(status);
        Serial.println("");
        numOfDevices--;
    }
    
# 146 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino" 3
   __asm__ __volatile__ ("sei" ::: "memory")
# 146 "E:\\toshiba\\progs\\Arduino\\prograns\\owireNet\\oneWire\\oneWire.ino"
        ; //enable interrupts for other tasks
}


void setup()
{
    Serial.begin(19200);
}


void loop()
{
    OneWire_Tasks();
}
