/*
 * delays.cpp
 * Created: 01/07/2019 21:21:09
 *  Author: nassorri

    For parasite mode this circuitry will 
    power device(s) during conversion time.

    
                                         o VCC                      o GND                         o VCC
                                         |                          |                             |
                                  o------|                          |           Parasite Mode     |           Powered Mode
                                  |      |                          |         |--------------     |        |-------------
                                  |      /                          |---------| VCC         |     ---------| VCC        |
    STRONG_PULL_UP_PIN        |---|      \ 1-WIRE PULL_UP           |   |-----| DQ          |     ---------| DQ         |
          o--\/\/\/\/---------|          / RESISTOR                 |---|-----| GND         |     |    ----| GND        |
                              |---|      \                              |     |--------------     |    |   |-------------
                                  |      |                              |                         |    |
                                  |      |                              |                         |    o GND
                                  |      |                              |                         |
                                  |------|------------------------------o-------------------------o-------o DQ-PIN of MCU 
                                  
    For device(s) in powered mode
    that is not necessary.
*/


#ifndef OW_DELAYS_H_
#define OW_DELAYS_H_



#ifndef F_CPU
#define  F_CPU 16000000UL
#endif


#include <Arduino.h>
#include <avr/io.h>
#include <inttypes.h>
#include <ctype.h>
#include <util/delay.h>



#define SCRATCHPAD_DLY  10      // delay for scratch pad parasite mode.
#define CONVTEMP_DLY    750     // 750 ms for most of the device(s)
                                // Time conversion in parasite mode.
                                
#define INPUT                   0
#define OUTPUT                  1
#define LOW                     0


#define  _tLOW1  1      //Time writing 1
#define  _tLOW0  60     //Time writing 0
#define  _tLOWR  1      //Time read operation
#define  _tRDV   15     //Time Read Valid
#define  _tSLOT  60     //Time Total Bit
#define  _tRSTL  600    //Time Reset Pulse low
#define  _tRSTH  600    //Time Reset Pulse Hi
#define  _tPDL   60     //Time response Lo
#define  _tPDH   15     //Time response Hi
#define  _tREC   1      //Time Recovery


#define Delay_ow_1us()      _delay_us(_tLOW1)
#define Delay_ow_480us()    _delay_us(_tRSTH)
#define Delay_ow_75us()     _delay_us((_tPDL + _tPDH) - 10)
#define Delay_ow_405us()    _delay_us((_tRSTL - (_tPDL + _tPDH)))
#define Delay_ow_46us()     _delay_us(((_tPDL - _tPDH) + _tREC))
#define Delay_ow_60us()     _delay_us((_tSLOT - 5))
#define Delay_ow_15us()     _delay_us((_tRDV - 5))


#define Delay_ow_10ms()     _delay_ms(10)


#endif /* OW_DELAYS_H_ */
